/*
* Loader / BabeSucker 0.2
* (c) 1999 Keith Paterson
*
*/

import java.io.*;
import java.net.*;
import java.util.*;

/**
*
* 
*
*/



public class Loader
{

/**
*
* @param args
*
*/
  
	static public void main(String args[])
	{
		try
		{
		  if( args.length == 2 )
		  {
		    if( args[0].equalsIgnoreCase("get") )
		    {
          Hashtable h = new Hashtable();
		      try
		      {		        
            java.io.BufferedReader f = new java.io.BufferedReader( new java.io.FileReader("./loader.url") );
            while( f.ready() )     
              h.put( "url", f.readLine() );
            f.close();
          }
          catch( Exception e )
          {
            System.out.println( e.getMessage() );  
          }
          if( !h.contains(args[1]) )
          {
            java.io.BufferedWriter fout = new java.io.BufferedWriter( new java.io.FileWriter("./loader.url") );          
		        fout.write( args[1] + "\n");
		        Enumeration e = h.elements();
		        while( e.hasMoreElements() )
		          fout.write( (String) e.nextElement() );
		        fout.close();
		      }
		      Loader l = new Loader();
		      l.get( args[1] );
		    }
		  }
		  else if( args.length == 1 )
		  {
 		    if( args[0].equalsIgnoreCase("scan") )
		    {
		      new Loader().writeHTML();		      
		    }		    
 		    else if( args[0].equalsIgnoreCase("renew") )
		    {
		      new Loader().get();		      
		    }
		    else
		      usage();
		  }
		  else
		  {
		    usage();
		  }
		}
		catch (Throwable t)
		{
			System.err.println(t);
			t.printStackTrace();
			//Ensure the application exits with an error condition.
			System.exit(1);
		}
  }


  static void usage()
  {
		System.out.println( "Usage :");
		System.out.println( "Loader batch");
		System.out.println( "Loader scan");
		System.out.println( "Loader get URL");
		System.out.println( "URL can contain either Numberranges e.g. [1-99]");
		System.out.println( "or StringLists e.g. [hk,dp]");    
  }

/**
*
*
*/
  
  void get() throws Exception
  {
    java.io.BufferedReader f = new java.io.BufferedReader( new java.io.FileReader("./loader.url") );
    Vector v = new Vector();
    while( f.ready() )     
      v.addElement( f.readLine() );
    for( int i = 0; i < v.size(); i++ )
      get( (String) v.elementAt(i));
  }

/**
*
* This methods scans the given url and recursively calls itself.
* @param url
*
*/

  
		
	void get( String url )
	{	  
	  if( url.indexOf( "[") == -1 )
	  {
	    load( url );
	    return;
	  }
	  String firstbit = url.substring( 0, url.indexOf( "[") );
    String regex    = url.substring(url.indexOf( "[") + 1, url.indexOf( "]") );
	  String lastbit  = url.substring( url.indexOf( "]") + 1, url.length() );
	  int[]    minmax     = new NumberRange().parse( regex );
	  String[] letters    = new LetterList().parse( regex );
	  if( minmax != null )	  
	  {
	    for( int i = minmax[0]; i < minmax[1]; i++ )
	    {
	      int second = new Integer( minmax[1] ).toString().length() - new Integer( i ).toString().length();
	      String number = "";
	      for( int k = 0; k < second; k++ )
	        number += "0";
	      number += i;
	      get( firstbit + number + lastbit );
	    }
	  }
	  else if( letters != null )
	  {
	    for( int i = 0; i < letters.length; i++ )
	    {
	      get( firstbit + letters[i] + lastbit );
	    }
	  }
	  System.out.println("Finished getting round !!");
	}

/**
*
* @param url
*
*/
	
	public void load( String url )
	{
	  try
	  {
		  File f = new File( ".",url.substring( url.lastIndexOf("/"), url.length() ) );	 
		  if( f.exists() )
		  {
  	    System.out.println( "Exists : " + url );	    
		    return;
		  }
	    System.out.println( "Getting : " + url );	    
   	  URLConnection pic = ( new URL( url ) ).openConnection();   	  
   	  
		  DataInputStream d = new DataInputStream( new BufferedInputStream( pic.getInputStream(), 3000000  ));	   	  
		  byte[] b;
		  if( pic.getContentLength() > 0 )
		  {
		    b = new byte[ pic.getContentLength() ];
		    d.readFully(b);
		  }
		  else
		  {
		    b = readFully( d );
		  }
//		  d.close();
	    System.out.println( "Writing : " + f.getName() + " " + b.length + " Bytes ");		  
  		DataOutputStream dos = new DataOutputStream( new FileOutputStream( f ));
  		dos.write(b);
  		dos.close();
  	}
  	catch( Exception e )
  	{
  	  System.out.println( e );
  	}
	}

/**
*
* This method scans the current directory and generates a simple html file with the images.
*/
	
	public void writeHTML()
	{
	  System.out.println("Writing HTML");
	  try
	  {
	    File dir = new File(".");
	    String[] s = dir.list();
  	  DataOutputStream dos = new DataOutputStream( new FileOutputStream(  "index.html" ) );
  	  dos.writeBytes("<HTML>\r\n");
  	  for( int i = 0; i < s.length; i++ )
  	  {
  	    if( s[i].endsWith(".jpg") || s[i].endsWith(".gif") )
  	      dos.writeBytes("<IMG src=" + s[i] + ">\r\n");
  	  }
  	  dos.writeBytes("</HTML>\r\n");
  	  dos.close();
  	}
  	catch( Exception e )
  	{
  	  System.out.println( e );
  	}
	}

/**
*
* @param d
*
*/
	
	public byte[] readFully( DataInputStream d )
	{
	  byte[] puffer = new byte[10];
	  byte[] result = new byte[0];
	  int pPos = 0;
	  try
	  {
	    while( true )
	    {
	      pPos = -1;
	      for( int i = 0; i < puffer.length; i++ )
	      {
	        puffer[i] = 'F';
	        puffer[i] = d.readByte();
	        pPos = i + 1;
	      }
	      byte[] temp = new byte[ result.length ];
	      System.arraycopy(result, 0, temp, 0, result.length );
	      result = new byte[ temp.length + puffer.length ];
	      System.arraycopy(temp, 0, result, 0, temp.length );
	      System.arraycopy(puffer, 0, result, temp.length, puffer.length );
	    }
	  }
	  catch( EOFException e )
	  {
	    byte[] temp = new byte[ result.length ];
	    System.arraycopy(result, 0, temp, 0, result.length );
	    result = new byte[ temp.length + pPos ];
	    System.arraycopy(temp, 0, result, 0, temp.length );
	    System.arraycopy(puffer, 0, result, temp.length, pPos );	    
  	  return result;    
	  }
	  catch( IOException e )
	  {
  	  return null;    
	  }
	}

/**
*
* @param proxyHost
* @param proxyPort
*
*/
	
	public void setProxy( String proxyHost, String proxyPort ) throws IOException, java.net.MalformedURLException
	{
    String authString = "userid:password"; 
    String auth = "Basic " + new sun.misc.BASE64Encoder().encode(authString.getBytes()); 
//    URL url = new URL("http://java.sun.com/"); 
//    URLConnection conn = url.openConnection(); 
    System.getProperties().put("http.proxySet", "true"); 
    System.getProperties().put("http.proxyHost", proxyHost); 
    System.getProperties().put("http.proxyPort", proxyPort); 
/*    conn.setRequestProperty("Proxy-Authorization", auth); 
    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream())); 
    String inputLine; 
    while ((inputLine = in.readLine()) != null) 
      System.out.println(inputLine); 
      in.close(); 
    } catch (...) {} 
    } 
    }*/ 	  
	}

/**
* This Class represents a range of numbers.
* It's intelligence will rise.
*/
	
	class NumberRange
	{
	  public int[] parse( String s )
	  {
	    int[] returned = new int[2];
	    if( s.indexOf("-") == -1 )
	      return null;
	    returned[0] = Integer.parseInt( s.substring( 0, s.indexOf("-") ) );
	    returned[1] = Integer.parseInt( s.substring( s.indexOf("-") + 1, s.length() ) );	
	    return returned;
	  }
	}		

/**
* This Class represents a range of numbers.
* It's intelligence will rise.
*/
	
	
	class LetterList
	{
	  public String[] parse( String s )
	  {
	    if( s.indexOf(",") == -1 )
	      return null;
	    StringTokenizer st = new StringTokenizer( s, "," );
	    String[] returned = new String[ st.countTokens() ];
	    for( int i=0; i< returned.length; i++ )
	      returned[i] = st.nextToken();
	    return returned;
	  }
	}		
}